/* PROGRAM R.Tutor  ( a home-grown tutorial for writing applications using resources */
/* Part 1 - starting up & shutting down the tools from a ToolStartup List kept in a resource */
/* Part 2 - add a menu bar that is kept in a resource */

#include <types.h>
#include <INTMATH.h>
#include <MEMORY.h>
#include <MISCTOOL.h>
#include <LOCATOR.h>
#include <DESK.H>
#include <QUICKDRAW.h>
#include <EVENT.h>
#include <CONTROL.h>
#include <WINDOW.h>    
#include <MENU.h>    


#define  kStartStopID    1L    /* used when starting and shutting down tools */

/*---------------------- Menus & Menu Bars ---------------------------*/
#define  kMenuBarID      1L   /* resource ID of the menu bar itself */

    /* define all the menu id's */
#define  kAppleMenuID   1000L  /* resource ID of the Apple menu */
#define  kFileMenuID    2000L  /* resource ID of the File menu */
#define  kEditMenuID    3000L  /* resource ID of the Edit menu */

    /* now, define the menu item id's */
#define   kAboutBoxID   1001L  /* resource ID of the About Box menu item */ 

#define   kNewItemID    2001L  /* resource ID of the New Item in File menu */
#define   kOpenItemID   2002L  /* resource ID of the Open item in File menu */ 
#define   kCloseItem     255L  /* the "Close" item */
#define   kSaveItem     2004L  /* the "Save" item */
#define   kSaveAsItem   2005L  /* the "Save As..." item */
#define   kRevertItem   2006L  /* the "Revert to Saved" item */
#define   kPageItem     2007L  /* the "Page Setup..." item */
#define   kPrintItem    2008L  /* the "Print..." item */
#define   kQuitItem     2009L  /* the "Quit" item */

#define   kUndoItem      250L  /* the "Undo" item */
#define   kCutItem       251L  /* the "Cut" item */
#define   kCopyItem      252L  /* the "Copy" item */
#define   kPasteItem     253L  /* the "Paste" item */
#define   kClearItem     254L  /* the "Clear" item */
#define   kSelectItem   3001L  /* the "Select All" item */
#define   kShowClipItem 3002L  /* the "Show ClipBoard" item */


    
/* declare all of the global variables that we'll be using */    
unsigned   gMyMemID;    /* holds the ID returned by MMStartup */
Ref       gToolListRef; /* the list of tools used to start and stop the tools */
Boolean   gPunt;        /* TRUE if it's time to quit the app */




/* ------------------------------------------------------------------------ */
/* the following procedure installs the menu bar from a resource */

do_make_menus()
{ 
   MenuBarRecHndl my_mbar_hndl;
   word menu_bar_height; 
  { 

   /* the next three calls are ALL required to bring the menu bar in from */
   /* the resource fork AND make it the current system menu bar.  For */
   /* details, see the IIGS Toolbox Reference, under NewMenuBar2  */
  my_mbar_hndl = NewMenuBar2(refIsResource, kMenuBarID, nil); 
  SetSysBar(my_mbar_hndl); 
  SetMenuBar(nil);

   /* now, add NDA's, adjust the sizes of the menus, and draw the menu bar */
   /* note the casting to "word" for kAppleMenuID!  FixAppleMenu needs a word */
   /* but most places need resource ID's to be longs, so the constant is */
   /* defined as a LONG and cast to a WORD here - this is a MAJOR pain to */
   /* debug if you don't know about it! */
  FixAppleMenu((word)kAppleMenuID); /* adds NDA's */
  menu_bar_height =  FixMenuBar(); /* adjust the sizes */
  DrawMenuBar();  /* draw the new menu bar and enjoy! */ 
  }
}

/* ------------------------------------------------------------------------ */
/* the following procedure is responsible for starting the tools (using the */
/* list in a resource) if the SartupTools call fails, then gPunt will */
/* contain "TRUE", so we can abort the app the global variable for this app's */
/*  memory id is acquired here as well. */

do_init_rom() /* on the GS, start up the tools here */
{
    gMyMemID = _ownerid; /* find out our memory id & save it for later */

    /* crank 'em up! */
    gToolListRef = StartUpTools(gMyMemID,refIsResource,kStartStopID);
    
    if (_toolErr == noError)
      {      /* there was no error, so the app can continue starting up */
        gPunt = FALSE;
      }
    else
      {     /* something went wrong, so set gPunt to indicate the failure */
        gPunt = TRUE;
      }
}



/* ------------------------------------------------------------------------ */
/* the following procedure is the main application itself. */
/* don't forget to add the code that will check the message center to see if */
/* this app was launched by clicking on its icon or by clicking on a data */
/* file created by this app.  If the data file was clicked on, then grab its */
/* name out of the message center and open it instead of opening the */
/* untitled window. */

main()
{    
    do_init_rom();    /* get my memory id, start the tools, & set gPunt */
    if (gPunt == FALSE)
      {
        do_make_menus();  /* insert the menu bar */
        SysBeep();
        SysBeep();
        SysBeep();
      }
    ShutDownTools(refIsHandle,gToolListRef); /* shut down the tools and quit */
} /* end of main program */
